<?php
namespace org\apache\maven\POM\_4_0_0;

/**
 * @xmlNamespace http://maven.apache.org/POM/4.0.0
 * @xmlType
 * @xmlName BuildBase
 * @var org\apache\maven\POM\_4_0_0\BuildBase
 * @xmlDefinition 3.0.0+
 */
class BuildBase
{

    
    /**
     * @Definition
                        The default goal (or phase in Maven 2) to execute when none is specified for
                        the project.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName defaultGoal
     * @var string
     */
    public $defaultGoal;
    /**
     * @Definition
                        This element describes all of the classpath resources such as properties files
                        associated with a
                        project. These resources are often included in the final package.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName resources
     */
    public $resources;
    /**
     * @Definition
                        This element describes all of the classpath resources such as properties files
                        associated with a
                        project's unit tests.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName testResources
     */
    public $testResources;
    /**
     * @Definition
                        The directory where all files generated by the build are placed.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName directory
     * @var string
     */
    public $directory;
    /**
     * @Definition
                        The filename (excluding the extension, and with no path information) that the
                        produced artifact
                        will be called. The default value is
                        <code>${artifactId}-${version}</code>.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName finalName
     * @var string
     */
    public $finalName;
    /**
     * @Definition
                        The list of filter properties files that are used when filtering is enabled.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName filters
     */
    public $filters;
    /**
     * @Definition
                        Default plugin information to be made available for reference by
                        projects derived from this one. This plugin configuration will not
                        be resolved or bound to the lifecycle unless referenced. Any local
                        configuration for a given plugin will override the plugin's entire
                        definition here.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName pluginManagement
     * @var org\apache\maven\POM\_4_0_0\PluginManagement
     */
    public $pluginManagement;
    /**
     * @Definition
                        The list of plugins to use.

     * @xmlType element
     * @xmlNamespace http://maven.apache.org/POM/4.0.0
     * @xmlMinOccurs 0
     * @xmlName plugins
     */
    public $plugins;
} // end class BuildBase
